(function($) {

	$(document).ready(function() {
		$('#muybridge-gallery').gallery();
		$('#issue-gallery').gallery();
		$('#muybridge-page-gallery').gallery({
			hideCntrl : true,
			initialHide : true
		});
		
	});
	var setSectionColor = function(node) {
		$.each($('.section'), function(i, item) {
			$(item).css('color', 'black');
		});
		$(node).css('color', '#0000ff');
	};
	var loadImg = function(node) {
		var img = new Image(), imgNode = $('img', node);
		$(img).load(function() {
			$(this).hide();
			node.fadeIn();
		}).attr({
			src : imgNode.attr('src')
		});
	};

	$.fn.gallery = function(attrs) {
		var curr = $('.gallery li', this).first(), 
			section = 'still1',
			self = this;
		
		var attrs = attrs || {
			
		};
		
		if(!attrs.hideCntrl) {
			$('.gallery-cntrl', this).show();
		}
		if(!attrs.initialHide) {
			curr.show();
		}
		
		$('.section').click(function() {
			$('.gallery-wrap', self).show(); // .css('visibility', 'visible');
			$('.gallery-cntrl', self).show();
			$('body').css('background', 'none');
			$('#thanks-to-start').first().hide();
			section = $(this).attr('href');
			curr.hide();
			setSectionColor(this);
			curr = $('.gallery li[rel="' + section + '"]', self).first();
			loadImg(curr);
			return false;
		});
		
		$('.prev', this).click(function() {
			curr.hide();
			if (curr.prev().attr('rel') != section) {
				section = curr.attr('rel');
			}
			if (curr.prev().length === 0) {
				curr = $('.gallery li', self).last();
			} else {
				curr = curr.prev();
			}
			if (curr.attr('rel') != section) {
				section = curr.attr('rel');
				setSectionColor($('#' + section));
			}
			loadImg(curr);
			return false;
		});
		$('.next', this).click(function() {
			curr.hide();
			if (curr.next().length === 0) {
				curr = $('.gallery li', self).first();
			} else {
				curr = curr.next();
			}
			if (curr.attr('rel') != section) {
				section = curr.attr('rel');
				setSectionColor($('#' + section));
			}
			loadImg(curr);
			return false;
		});
	};

})(jQuery);