<?php
/**
 * The Header for our theme.
 *
 * @package WordPress
 * @subpackage TSI
 * @since TSI 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title>
<?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'tsi' ), max( $paged, $page ) );

?>
</title>

<link rel="shortcut icon" href="/tsi.ico" type="image/x-icon" />

<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>
</head>

<body <?php body_class(); ?>>
<div id="center" class="hfeed">
	<div id="header">
		<div class="container">
			<h1>The T/Shirt Issue</h1>
			<ul id="nav-bar">
				<li <?php if (get_meta_page($wp_query) == 'none-basics' || get_parent_page($wp_query) == 'none-basics') echo 'class="current"' ?>>
					<a rel="sub" href="/index.php/none-basics">non basics</a>/
					<ul>
						<li><a href="/index.php/none-basics/t-shirt-issue">2008 / the-t-shirt-issue</a></li>
					</ul>
				</li>
				<li><a href="/index.php/blog">blog</a>/</li>
				<li <?php if (is_page('about')) echo 'class="current"' ?>>
					<a rel="sub" href="/index.php/facts">facts</a>/
					<ul>
						<li><a href="/index.php/facts/about">about</a></li>
					</ul>
				</li>				
				<li <?php if (is_page('contact')) echo 'class="current"' ?>><a href="/index.php/contact">contact</a></li>
			</ul>
		</div>
	</div>
